/*
 * Decompiled with CFR 0.152.
 */
package org.infernalstudios.infernalexp.network;

import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkEvent;

public class WhipReachPacket {
    private final UUID playerUUID;
    private static final Random random = new Random();

    public WhipReachPacket(UUID playerUUID) {
        this.playerUUID = playerUUID;
    }

    public static void encode(WhipReachPacket message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.playerUUID);
    }

    public static WhipReachPacket decode(FriendlyByteBuf buffer) {
        return new WhipReachPacket(buffer.m_130259_());
    }

    public static void handle(WhipReachPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            double distance;
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            double reach = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() + 1.0;
            Vec3 eyePos = player.m_20299_(1.0f);
            Vec3 lookVec = player.m_20154_();
            Vec3 reachVec = eyePos.m_82549_(lookVec.m_82542_(reach, reach, reach));
            AABB playerBox = player.m_20191_().m_82369_(lookVec.m_82490_(reach)).m_82377_(1.0, 1.0, 1.0);
            EntityHitResult entityTraceResult = ProjectileUtil.m_37287_((Entity)player, (Vec3)eyePos, (Vec3)reachVec, (AABB)playerBox, target -> !target.m_5833_() && target.m_6084_(), (double)(reach * reach));
            BlockHitResult blockTraceResult = player.m_20193_().m_45547_(new ClipContext(eyePos, reachVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
            if (entityTraceResult != null && (distance = eyePos.m_82557_(entityTraceResult.m_82450_())) < reach * reach && distance < eyePos.m_82557_(blockTraceResult.m_82450_())) {
                player.f_20922_ = (int)player.m_36333_();
                player.m_20193_().m_6263_((Player)player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.4f + 1.2f));
                if (player != null && player.m_20194_() != null) {
                    ServerPlayer serverPlayer = player.m_20194_().m_6846_().m_11259_(message.playerUUID);
                    Entity target2 = entityTraceResult.m_82443_();
                    if (serverPlayer != null && target2 != null && serverPlayer.m_20280_(target2) < reach * reach * (double)serverPlayer.m_36403_(0.0f)) {
                        serverPlayer.m_5706_(target2);
                        serverPlayer.m_20193_().m_6263_(null, serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (random.nextFloat() * 0.4f + 1.2f));
                    }
                }
            }
        });
        context.get().setPacketHandled(true);
    }
}

